import { world } from "@minecraft/server";
import { FatItem } from "./item/Fat";
import { chrysalis_grow, chrysalis_update } from "./block/Chrysalis";

/**
 * 1.20.10 version was canceled!
 * We can just uncomment this codes after 1.21.20 and take
 * back the new mechanics with Custom Components.
 */
export class Register {
  constructor() {
    
    Register.#registerBlockEvents();
    Register.#registerItemEvents();
   
  }

  static #registerBlockEvents() {

    /*
      A best practice is create a class with this methods and bind it.
      We are using Register.js for this to make codes more simple
      and redeable. See item/Fat.js for a binded class example.

	    @see - https://learn.microsoft.com/en-us/minecraft/creator/documents/customcomponents?view=minecraft-bedrock-stable
    */
    e.blockComponentRegistry.registerCustomComponent('sf_nba:chrysalis_grow', { onRandomTick: chrysalis_grow });
    e.blockComponentRegistry.registerCustomComponent('sf_nba:chrysalis_update', { onTick: chrysalis_update });
    e.blockComponentRegistry.registerCustomComponent('sf_nba:three_stage_egg', { onRandomTick: three_stage_egg_step });
    e.blockComponentRegistry.registerCustomComponent('sf_nba:one_stage_egg', { onRandomTick: one_stage_egg_step });
    e.blockComponentRegistry.registerCustomComponent('sf_nba:delicate_egg', { onStepOn: damage_egg, onEntityFallOn: damage_egg });
  }

  static #registerItemEvents() {
    world.beforeEvents.worldInitialize.subscribe((e) => {
      e.itemComponentRegistry.registerCustomComponent('sf_nba:fat', new FatItem());
    });
  }
}

new Register();